IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Productos_Cobros_Detalle_FP') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Productos_Cobros_Detalle_FP
END
GO

CREATE PROCEDURE [dbo].[CPJ_Productos_Cobros_Detalle_FP] @pJsonRecibido VARCHAR(8000)


AS 
SET NOCOUNT ON

/*Parametros*/
DECLARE		@pId_Usuario			INT,
			@pFlagUsarTrans			TINYINT,
			@pModoDebug				TINYINT,
			@pFechaDesde			DATETIME,
			@pFechaHasta			DATETIME,
			@pPeriodoDesde			DATETIME,
			@pPeriodoHasta			DATETIME,
		    @pFlag_Liquidacion		TINYINT,
		    @pId_Periodo_Caja		INT,
		    @pFlag_FPago			TINYINT,
		    @pTipo_Cob				CHAR(1),		-- vacio = todos  M = Manual L=Lote
			@pFormato				VARCHAR(3),     --D  Detallado   F Resumen por Familia     CF  Resumen por Cobrador Familia  CFM  Resumen por Cob,Familia,Mes  P Producto  T Tipo/Categoria    CTA  Por cuenta y CC
			@pFlag_Filtrar_Fam		TINYINT,
			@pFlag_Inc_Fact_Periodo	TINYINT,		--Incluye lo facturado en el periodo y no este cobrado solo para formato  D
			@pFlag_Filtrar_Prod		TINYINT,
			@pFlag_No_Rec_Aplic		TINYINT,		-- Se agrega flag para validar si no se requiere Recibos de Aplicacion- 2021/08/12  0=Con Recibos de Aplica, 1= Sin Recibos de Aplica
			@pFlag_Filtrar_CC		TINYINT,
			@pId_Centro_Costo		VARCHAR(10),
            @pFlag_Filtrar_Caja		TINYINT,
			@pRegenerar_Archivo		CHAR(1),
			@pId_Familia            INT,
			@pId_Producto           VARCHAR(14),
			@pId_Cliente            INT,
			@pRegenarUltDias		INT

			
Declare @Imp_Acuenta Decimal(20,2)
       ,@Imp_Aplic Decimal(20,2)

SET @pId_Usuario				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Usuario')), 0)
SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)

SET @pFechaDesde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaDesde')),GETDATE())
SET @pFechaHasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaHasta')),GETDATE())

SET @pRegenarUltDias			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'RegenarUltDias')),0)
IF @pRegenarUltDias > 0 
BEGIN
	SET @pFechaDesde				= DATEADD(DAY, @pRegenarUltDias * -1 ,CONVERT(DATE,GETDATE()))
	SET @pFechaHasta				= GETDATE()
	PRINT @pFechaDesde
	PRINT @pFechaHasta
END



SET @pPeriodoDesde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'PeriodoDesde')),'')
SET @pPeriodoHasta				= CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'PeriodoHasta'))
 IF @pPeriodoHasta IS NULL


SET	@pFlag_Liquidacion			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Liquidacion')), 0)
SET	@pId_Periodo_Caja			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Periodo_Caja')), 0)
SET	@pFlag_FPago				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_FPago')), 0)
SET	@pTipo_Cob					= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJsonRecibido,'Tipo_Cob')), '')
SET	@pFormato					= ISNULL(CONVERT(VARCHAR(3), dbo.CF_JSON_VALUE(@pJsonRecibido,'Formato')), 0)
SET	@pFlag_Filtrar_Fam			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Filtrar_Fam')), 0)
SET	@pFlag_Inc_Fact_Periodo		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Inc_Fact_Periodo')), 0)
SET	@pFlag_Filtrar_Prod			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Filtrar_Prod')), 0)
SET @pFlag_No_Rec_Aplic			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_No_Rec_Aplic')), 0)
SET @pFlag_Filtrar_CC			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Filtrar_CC')), 0)
SET @pId_Centro_Costo	        = ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Centro_Costo')), '')
SET @pFlag_Filtrar_Caja			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Filtrar_Caja')), 0)
SET @pRegenerar_Archivo			= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJsonRecibido,'Regenerar_Archivo')),'S')
SET	@pId_Familia 		    	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Familia')), 0)
SET	@pId_Producto	            = ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Producto')), '')
SET	@pId_Cliente 		    	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Cliente')), 0)
            

 SELECT @Imp_Acuenta = SUM(ISNULL(Acuenta,0)), @Imp_Aplic = SUM(ISNULL(Aplic,0))
 		FROM RPT_Productos_Cob_Detalle c 
		WHERE C.fecha_rec >= @pFechaDesde 
	    AND C.fecha_rec < DATEADD(dd,1,@pFechaHasta)


SELECT V.Id_Tipo_Val,ISNULL(v.Id_tarjeta,'') AS  Id_Tarjeta ,T.Descripcion AS Descripcion
	,ISNULL(v.id_cta_Banco,0) AS Id_Cta_Banco, B.Descripcion AS CtaBanco,
	 CONVERT(decimal(20,2),SUM(ROUND(v.importe * C.coef_pago * C.coef_val * C.Coef,2))) AS Total
	INTO #Detalle
		FROM RPT_Productos_Cob_Detalle c ,Valores v, Valores_Mov m, Valores_Tarjetas_Cred T, Bancos_Ctas B 
		WHERE c.id_trans_rec = m.id_trans
		AND m.id_valor = v.id_valor 
		AND ISNULL(v.Id_Tarjeta,'')  = T.Id_Tarjeta 
		AND ISNULL(V.Id_Cta_Banco,0) = B.Id_Cta_Banco
	    AND C.fecha_rec >= @pFechaDesde 
	    AND C.fecha_rec < DATEADD(dd,1,@pFechaHasta)
    GROUP BY V.Id_Tipo_Val,ISNULL(v.Id_Tarjeta,''),T.Descripcion,ISNULL(v.id_cta_Banco,0),B.Descripcion
    ORDER BY V.Id_Tipo_Val

 	UPDATE #Detalle SET Descripcion = '' WHERE descripcion = 'NO DEFINIDA'
	UPDATE #Detalle SET Descripcion = 'EFECTIVO' WHERE Id_Tipo_Val = 'EFE'
	UPDATE #Detalle SET Descripcion = 'CHEQUE' WHERE Id_Tipo_Val = 'CH3'
	UPDATE #Detalle SET Descripcion = 'AJUSTES' WHERE Id_Tipo_Val = 'AJU'



	IF @Imp_Aplic <> 0
	   INSERT INTO #Detalle (Id_Tipo_Val, Id_Tarjeta , Descripcion, Id_cta_banco, CtaBanco, Total) VALUES ('APL','','N/C - APLICACIONES','','',@Imp_Aplic)

--	IF @Imp_Acuenta <> 0
--	   INSERT INTO #Detalle  (Id_Tipo_Val, Id_Tarjeta , Descripcion, Id_cta_banco, CtaBanco, Total) VALUES ('CTA','','PAGOS A CUENTA','','',@Imp_Acuenta)


	SELECT *  FROM #Detalle ORDER BY CtaBanco DESC ,Id_Tipo_Val DESC ,Descripcion

	DROP TABLE #Detalle



/*

EXEC CPJ_Productos_Cobros_Detalle_FP '{"Id_Usuario":"-1"
,"Equate":"90"
,"FechaDesde":"20250501"
,"FechaHasta":"20250531"
,"Flag_Liquidacion":"0"
,"Flag_FPago":"0"
,"Tipo_Cob":"-"
,"Formato":"D"
,"Flag_Filtrar_Prod":"0"
,"Flag_Filtrar_Fam":"0"
,"Flag_Filtrar_Caja":"0"
,"Id_Familia":""
,"Id_Producto":""
,"Id_Cliente":""
,"Regenerar_Archivo":"n"
,"Flag_Inc_Fact_Periodo":"0"}' 

*/